//=============================================================================
// DawnsWarpZInfo.
// Version: 1.0
// $DateTime: Thu, 02/05/2009 01:19:58 pm$
// Author: Dawn Knight
// UT Version Coded/Tested: 4.36.
//
// For making disjoint spaces appear as if they were connected;
// supports both in-level warp zones and cross-level warp zones.
//
// Uses Timer() rather than a Trigger to step through Destinations[n] and only
// switches if no PlayerPawns can observe the change.
//=============================================================================
class DawnsWarpZInfo extends WarpZoneInfo;

// Information set by the level designer.

var(WarpZoneInfo) float PauseInterval;

function Trigger( actor Other, pawn EventInstigator ) {}

final function bool PlayerMightSee()
{
	local Pawn aPawn;
	local Actor A;
	local vector HitLoc, HitNorm, PEyeHght;

	// Check PlayerPawns for visibility
	for( aPawn=Level.PawnList; aPawn!=None; aPawn=aPawn.nextPawn )
	{
		if( !aPawn.IsA('PlayerPawn') && !aPawn.IsA('Bot') )
			continue;

		// Get Location of PlayerPawn's EyeHeight
		PEyeHght = aPawn.Location+aPawn.EyeHeight*vect(0,0,1);

		// Check if PlayerPawn can see me
		foreach TraceActors( class'Actor', A, HitLoc, HitNorm,
				Location, PEyeHght )
		{
			if( (A == Self ) && ((vector(aPawn.ViewRotation) dot HitNorm) < 0) )
			{
				return True;
			}
		}
		foreach TraceActors( class'Actor', A, HitLoc, HitNorm,
				Location+CollisionHeight*vect(0,0,1), PEyeHght )
		{
			if( (A == Self ) && ((vector(aPawn.ViewRotation) dot HitNorm) < 0) )
			{
				return True;
			}
		}
		foreach TraceActors( class'Actor', A, HitLoc, HitNorm,
				Location-CollisionHeight*vect(0,0,1), PEyeHght )
		{
			if( (A == Self ) && ((vector(aPawn.ViewRotation) dot HitNorm) < 0) )
			{
				return True;
			}
		}
	}
	return False;
}

function Timer()
{
	local int nextPick;

	if (numDestinations == 0)
		return;

	if( PlayerMightSee() )
	{
		// Oops, try again a short time from now
		SetTimer( 0.5, False );
		return;
	}

	// Good, Players can't see me
	nextPick = 0;
	While( (nextPick < 8) && (Destinations[nextPick] != OtherSideURL )  )
		nextPick++;

	nextPick++;
	if ( (nextPick > 7) || (Destinations[nextPick] == "") )
		nextPick = 0;

	OtherSideURL = Destinations[nextPick];
	ForceGenerate();

	SetTimer( PauseInterval, False );
}

auto state() StartUp
{
	function BeginState()
	{
		SetTimer( PauseInterval, False );
		GoToState('');
	}
}

defaultproperties
{
     PauseInterval=10.0
     bStatic=False
     bCollideActors=True
     InitialState=StartUp
}
