//=============================================================================
// DawnsPlayerStart
// Version 1.1  05/17/2005
// $DateTime: Tue, 05/17/2005 02:10:36 pm$
//=============================================================================
class DawnsPlayerStart extends PlayerStart;


// A PlayerStart cycled on and off by a timer
var() float OnTime;
var() float OffTime;

function PostBeginPlay()
{
	super.PostBeginPlay();
	Enable('Timer');
	SetTimer(FRand()*(OnTime+OffTime), True); // deSync multiple DawnsPlayerStarts.
}

function Timer()
{
	if (bEnabled)
	{
		SetTimer(OffTime, False);
	}
	else
	{
		SetTimer(OnTime, False);
	}
	bEnabled=!bEnabled;
}

function Trigger( actor Other, pawn EventInstigator )
{
}

defaultproperties
{
     OnTime=10.0
     OffTime=20.0
     bStatic=False
}
