//=============================================================================
// DawnsNoTLZone for UT.  By Dawn Knight version 1.00
// $DateTime: Mon, 01/19/2009 04:42:01 pm$
//
// Allows Players to TL into Zone, but then removes TL from Player's
// Inventory.
//=============================================================================
class DawnsNoTLZone extends ZoneInfo;

var() bool   bTakeTLonEnter;
var() bool   bTakeTLonExit;
var() string NoTransLocatorMsg; // Tell Player "No TransLocators allowed"

var   pawn   EnteringPlayer[8];
var   pawn   LeavingPlayer[8];

final function TakeTL( Pawn Other )
{
	local TransLocator TL;

	TL = TransLocator( Other.FindInventoryType(class'TransLocator') );
	if (TL != None)
	{
		if( Other.Weapon == TL )
			Other.SwitchToBestWeapon();

		Other.DeleteInventory( TL ); // Remove it from Player's Inventory
		TL.Destroy(); // Remove it from the game

		if( TournamentPlayer( Other ) != None && NoTransLocatorMsg !="")
			Other.ClientMessage( NoTransLocatorMsg,	'CriticalEvent', True );
	}

	if ( Other.Weapon == None )
		Other.SwitchToBestWeapon();
}

function Timer()
{
	local int i;
	local Pawn P;

	if ( bTakeTLonEnter )
	{
		for ( i=0; i<8; i++ )
		{
			if ( EnteringPlayer[i] != None )
			{
				TakeTL( EnteringPlayer[i] );
				EnteringPlayer[i] = None;
			}
		}
	}
	if ( bTakeTLonExit )
	{
		for ( i=0; i<8; i++ )
		{
			if ( LeavingPlayer[i] != None )
			{
				TakeTL( LeavingPlayer[i] );
				LeavingPlayer[i] = None;
			}
		}
	}
}

// When an actor enters this zone.
event ActorEntered( actor Other )
{
	local int i;
	local actor A;

	if( bNoInventory && Other.IsA('Inventory') && (Other.Owner == None) )
	{
		Other.LifeSpan = 1.5;
		return;
	}

	if( pawn(Other)!=None && pawn(Other).bIsPlayer && !pawn(Other).IsA('Spectator') )
	{
		if( ++ZonePlayerCount==1 && ZonePlayerEvent!='' )
			foreach AllActors( class 'Actor', A, ZonePlayerEvent )
				A.Trigger( Self, Pawn(Other) );
		if( bTakeTLonEnter && DeathMatchPlus(Level.Game)!=None &&
				!DeathMatchPlus(Level.Game).bUseTranslocator )
		{
			// Can't take TL on this tick because Translocator's Translocate()
			// function may have called this Zone changing event.  If so, it is still
			// executing and expecting TL to be valid upon return from this call.
			for ( i=0; i<8; i++ )
			{
				if ( EnteringPlayer[i] == None )
				{
					EnteringPlayer[i] = pawn(Other);
					break;
				}
			}
			SetTimer( 0.2, False );
		}
		return;
	}

	if ( bMoveProjectiles && (ZoneVelocity != vect(0,0,0)) )
	{
		if ( Other.Physics == PHYS_Projectile )
			Other.Velocity += ZoneVelocity;
		else if ( Other.IsA('Effects') && (Other.Physics == PHYS_None) )
		{
			Other.SetPhysics(PHYS_Projectile);
			Other.Velocity += ZoneVelocity;
		}
	}
}

// When an actor leaves this zone.
event ActorLeaving( actor Other )
{
	local int i;
	local actor A;

	if( pawn(Other)!=None && pawn(Other).bIsPlayer && !pawn(Other).IsA('Spectator') )
	{
		if( --ZonePlayerCount==0 && ZonePlayerEvent!='' )
			foreach AllActors( class 'Actor', A, ZonePlayerEvent )
				A.UnTrigger( Self, Pawn(Other) );
		if( bTakeTLonExit && DeathMatchPlus(Level.Game)!=None &&
				!DeathMatchPlus(Level.Game).bUseTranslocator )
		{
			// Can't take TL on this tick because Translocator's Translocate()
			// function may have called this Zone changing event.  If so, it is still
			// executing and expecting TL to be valid upon return from this call.
			for ( i=0; i<8; i++ )
			{
				if ( LeavingPlayer[i] == None )
				{
					LeavingPlayer[i] = pawn(Other);
					break;
				}
			}
			SetTimer( 0.2, False );
		}
	}
}

// bStatic=False allows Timer function to run!
defaultproperties
{
     bStatic=False
     NoTransLocatorMsg="Translocator has disrupted!"
}
