//=============================================================================
// DawnsNoSeeSentry.
// Version: 1.0
// $DateTime: Wed, 12/31/2008 01:01:46 am$
// Author: Dawn Knight
// UT Version Coded/Tested: 4.36.
//
// Used by DawnsNoSeeMover to act as a TraceActors() object.  Each
// DawnsNoSeeMover may have several Sentrys placed strategically to help define
// the visible extents of the Mover and will be tested to see if any Players can
// see them.  Alternatively, bCheckTouchingOnly=True will cause the matching
// DawnsNoSeeMover to test this Actor for Collision with any PlayerPawns rather
// than visibility.  This is useful in areas where a PlayerPawn may otherwise
// become trapped as a result of proximity to an instantaneous movement of the
// matching DawnsNoSeeMover.
//
// Each DawnsNoSeeMover will search during its BeginPlay() for any Sentrys with
// matching tags.  The Mover will construct a linked list of the discovered
// Sentrys in order to access them quickly during gameplay.
//
// Originally a SubClass of Keypoint because it made more sense than other
// choices, this Actor needs to be an 'Inventory', 'Triggers', or 'NavigationPoint'
// because TransLocatorTargets will otherwise "Collide" with it due to a faulty
// Touch() function in TransLocatorTarget.  Of the three choices, 'Triggers'
// seems the least objectionable.
//=============================================================================


class DawnsNoSeeSentry extends Triggers;

// Sprite.
#exec texture Import File=Textures\Sentry.pcx Name=S_Sentry Mips=Off Flags=2

var() bool bCheckTouchingOnly;
var  DawnsNoSeeSentry NextSentry;

defaultproperties
{
     Texture=Texture'DawnsMapTools.S_Sentry'
     Drawscale=0.5
     CollisionRadius=12.000000
     CollisionHeight=36.000000
}

