//=============================================================================
// DawnsNSMCenter.
// Version: 1.0
// $DateTime: Sun, 02/08/2009 12:48:57 pm$
// Author: Dawn Knight
// UT Version Coded/Tested: 4.36.
//
// Used with LiftExits for BotPathing through DawnsNoSeeMovers.
//                               ***WARNING ***
// The rules for using LiftExits and DawnsNSMCenters are VERY strict!
// Every path consists of LiftExit-DawnsNSMCenter-LiftExit, which are linked by
// setting all 3 of their LiftTags to the same unique Name.  Additionally, the
// DawnsNSMCenter needs its Tag (don't confuse with LiftTag) set to the Event of
// the DawnsNoSeeMover so that the Mover can control the switching of the
// DawnsNSMCenter on and off per KeyFrame. Set the DawnsNSMCenter's ValidPath[]s
// accordingly.  Be SURE that the only resulting path after building Paths is
// the one intended and that this path is not 'short circuited' by any other
// path, whether blue or red, including a path from LiftExit to LiftExit that
// bypasses the DawnsNSMCenter.  If this happens, the logic created by the
// DawnsNSMCenter will be bypassed and Bots will try to navigate the path when
// it is blocked.  Whereas the DawnsNSMCenter will only connect to LiftExits
// that share the same LiftTag and nothing else, LiftExits will connect to any
// valid NavigationPoint, regardless of Tag, LiftTag, or anything else.  You
// must prevent the LiftTags from connecting in unexpected and undesired ways to
// other NavigationPoints to prevent 'short circuiting' the DawnsNSMCenters.
// Refer to DM-DawnsFermiBELL_TimeLabs.unr for examples of the correct usage of
// DawnsNoSeeMovers, DawnsNoSeeSentrys, and DawnsNSMCenters.
//=============================================================================

class DawnsNSMCenter extends LiftCenter;

// Sprite.
#exec texture Import File=Textures\DNSMCenter.pcx Name=S_Center Mips=Off Flags=2

var   DawnsNSMCenter  NextDNSMCenter;

// If this PathNode is valid for this Mover KeyFrame
var() enum  EValidPath
{
	VP_False,
	VP_True,
} ValidPath[8]; // Corresponds to the 8 possible KeyFrames of a DawnsNoSeeMover.

final function SetPath( byte KeyNumC )
{
	if ( ValidPath[KeyNumC] == VP_True )
		ExtraCost = 0;
	else
		ExtraCost = 100000000;
	if ( NextDNSMCenter != None )
		NextDNSMCenter.SetPath( KeyNumC );
}

defaultproperties
{
     ExtraCost=100000000
     Texture=Texture'DawnsMapTools.S_Center'
}
