//-----------------------------------------------------------
// DawnsBotAttractant - attracts Bots to its location
// Attraction is determined on a per Bot basis
// Attraction drops to zero for awhile once Bot has visited it
// to prevent Bot from camping around it
// Ver 1.0.0 by Dawn Knight
// $DateTime: Mon, 02/09/2009 10:30:12 am$
//-----------------------------------------------------------
class DawnsBotAttractant extends HealthVial;

var() float AttractionStrength;  // How much does a Bot want this?
var() float AttractionTimeout; // When Bot touches, turn off attraction for seconds

struct ABotTouched
{
    var int LastTouched;
    var string BotName;
};

var ABotTouched BotTouched[32];

// Become a pickup.
function BecomePickup()
{
	super.BecomePickup();
	bHidden       = true;
}

event float BotDesireability(Pawn Bot)
{
	local int i;

	for (i=0;i<32;i++)
	{
	 	if (BotTouched[i].BotName == Bot.PlayerReplicationInfo.PlayerName)
	 	{
	 	 	if (Level.TimeSeconds - BotTouched[i].LastTouched < AttractionTimeout)
	 	 	 	return 0.0; // Bot Touched us shortly ago
	 	 	else return AttractionStrength; // Bot hasn't Touched us recently
	 	}
	 	else if (BotTouched[i].BotName == "")
	 		return AttractionStrength; // Bot has NEVER Touched us before!
	}
	// We should NEVER get here - searched all 32 possible Bot slots!
	Warn("***** DawnsBotAttractant BotDesireability function: unrecognized Bot!!! *****");
	return AttractionStrength;
}

function PlayPickupMessage(Pawn Other);

auto state Pickup
{
	function Touch( actor Other )
	{
		local int i;

		if (!Other.IsA('Bot'))
			return;

		for (i=0;i<32;i++) // Assumes Bot Names are static during a game
		{
		 	if (BotTouched[i].BotName == "")
		 		BotTouched[i].BotName = Bot(Other).PlayerReplicationInfo.PlayerName;
		 	// above "if" will always fall thru to next "if" below...
			if (BotTouched[i].BotName == Bot(Other).PlayerReplicationInfo.PlayerName)
		 	{
		 		BotTouched[i].LastTouched = Level.TimeSeconds;
		 		return;
		 	}
		}
		// We should NEVER get here - searched all 32 possible Bot slots!
		Warn("***** DawnsBotAttractant Touch function: unrecognized Bot!!! *****");
	}
}

defaultproperties
{
     DrawType=DT_Sprite
     Texture=Texture'Engine.S_Inventory'
     bInstantRespawn=True
     bStatic=True
     bTravel=False
     HealingAmount=0
     PickupMessage=""
     ItemName="BotAttractant"
     RespawnTime=0.100000
     PickupSound=none
     ScaleGlow=1.000000
     CollisionRadius=14.000000
     CollisionHeight=16.000000
     AttractionStrength=3.000000
     AttractionTimeout=10.000000

}
