class ScriptedMale expands SHuman.WeaponHolder;

#exec obj load file=..\Textures\GothSkins.utx

function SetMovementPhysics()
{
	if (Physics == PHYS_Falling)
		return;
	if ( Region.Zone.bWaterZone )
		SetPhysics(PHYS_Swimming);
	else
		SetPhysics(PHYS_Walking);

	if ( Multiskins[0] == None)
//		Multiskins[0] = Default.Multiskins[0];
		Multiskins[0] = Texture'GothSkins.goth1';
	if ( Multiskins[1] == None)
//		Multiskins[1] = Default.Multiskins[1];
		Multiskins[1] = Texture'GothSkins.goth2';
	if ( Multiskins[2] == None)
//		Multiskins[2] = Default.Multiskins[2];
		Multiskins[2] = Texture'GothSkins.goth3';
	if ( Multiskins[3] == None )
//		Multiskins[3] = Default.Multiskins[3];
		Multiskins[3] = Texture'GothSkins.T_Blue4';
}


function PlayDying(name DamageType, vector HitLoc)
{
	BaseEyeHeight = Default.BaseEyeHeight;
	PlayDyingSound();
      
	if ( DamageType == 'Suicided' )
	{
		PlayAnim('Dead8',, 0.1);
		return;
	}

	// check for head hit
	if ( (DamageType == 'Decapitated') && !Level.Game.bVeryLowGore )
	{
		PlayDecap();
		return;
	}

	if ( FRand() < 0.15 )
	{
		PlayAnim('Dead2',,0.1);
		return;
	}

	// check for big hit
	if ( (Velocity.Z > 250) && (FRand() < 0.75) )
	{
		if ( FRand() < 0.5 )
			PlayAnim('Dead1',,0.1);
		else
			PlayAnim('Dead11',, 0.1);
		return;
	}

	// check for repeater death
	if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
	{
		PlayAnim('Dead9',, 0.1);
		return;
	}
    
	if ( (HitLoc.Z - Location.Z > 0.7 * CollisionHeight) && !Level.Game.bVeryLowGore )
	{
		if ( FRand() < 0.5 )
			PlayDecap();
		else
			PlayAnim('Dead7',, 0.1);
		return;
	}
  
	if ( Region.Zone.bWaterZone || (FRand() < 0.5) ) //then hit in front or back
		PlayAnim('Dead3',, 0.1);
	else
		PlayAnim('Dead8',, 0.1);
}

//Checkout
function PlayDecap()
{
	local carcass carc;

	PlayAnim('Dead4',, 0.1);
	if ( Level.NetMode != NM_Client )
	{
		carc = Spawn(class 'UT_HeadMale',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
		if (carc != None)
		{
			carc.Initfor(self);
			carc.Velocity = Velocity + VSize(Velocity) * VRand();
			carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
			carc.remoterole=role_simulatedproxy;
		}
	}
}

function PlayGutHit(float tweentime)
{
	if ( (AnimSequence == 'GutHit') || (AnimSequence == 'Dead8') )
	{
		if (FRand() < 0.5)
			TweenAnim('LeftHit', tweentime);
		else
			TweenAnim('RightHit', tweentime);
	}
	else if ( FRand() < 0.6 )
		TweenAnim('GutHit', tweentime);
	else
		TweenAnim('Dead8', tweentime);
}

function PlayHeadHit(float tweentime)
{
	if ( (AnimSequence == 'HeadHit') || (AnimSequence == 'Dead7') )
		TweenAnim('GutHit', tweentime);
	else if ( FRand() < 0.6 )
		TweenAnim('HeadHit', tweentime);
	else
		TweenAnim('Dead4', tweentime);
}

function PlayLeftHit(float tweentime)
{
	if ( (AnimSequence == 'LeftHit') || (AnimSequence == 'Dead9') )
		TweenAnim('GutHit', tweentime);
	else if ( FRand() < 0.6 )
		TweenAnim('LeftHit', tweentime);
	else
		TweenAnim('Dead9', tweentime);
}

function PlayRightHit(float tweentime)
{
	if ( (AnimSequence == 'RightHit') || (AnimSequence == 'Dead1') )
		TweenAnim('GutHit', tweentime);
	else if ( FRand() < 0.6 )
		TweenAnim('RightHit', tweentime);
	else
		TweenAnim('Dead1', tweentime);
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local float rnd;
	local Bubble1 bub;
	local bool bOptionalTakeHit;
	local vector BloodOffset, Mo;

	if (Damage > 1) //spawn some blood
	{
		if (damageType == 'Drowned')
		{
			bub = spawn(class 'Bubble1',,, Location 
				+ 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * BaseEyeHeight * vect(0,0,1));
			if (bub != None)
				bub.DrawScale = FRand()*0.06+0.04; 
		}
		else if ( damageType != 'Corroded' )
		{
			BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
			BloodOffset.Z = BloodOffset.Z * 0.5;
			if ( bGreenBlood )
				spawn(class 'UT_GreenBloodPuff',self,,hitLocation + BloodOffset, rotator(BloodOffset));
			else if ( (!Level.bDropDetail || (FRand() < 0.67))
				&& ((DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded')) )
			{
				Mo = Momentum;
				if ( Mo.Z > 0 )
					Mo.Z *= 0.5;
				spawn(class 'UT_BloodHit',self,,hitLocation + BloodOffset, rotator(Mo));
			}
			else
				spawn(class 'UT_BloodBurst',self,,hitLocation + BloodOffset);
		}
	}

	bFireFalling = false;
	bOptionalTakeHit = ( (Level.TimeSeconds - LastPainTime > 0.3 + 0.25 * skill)
						&& (Damage * FRand() > 0.08 * Health) && (Skill < 2)
						&& (GetAnimGroup(AnimSequence) != 'MovingAttack') 
						&& (GetAnimGroup(AnimSequence) != 'Attack') ); 

	PlayTakeHitSound(Damage, damageType, 2);
	if ( ((Weapon == None) || !Weapon.bPointing)
		 && (GetAnimGroup(AnimSequence) != 'Dodge') 
		&& (bOptionalTakeHit || (Momentum.Z > 140) 
			 || (Damage * FRand() > (0.17 + 0.04 * skill) * Health)) ) 
	{
		PlayHitAnim(HitLocation, Damage);
/*		if ( (Enemy != None) && (FRand() * Skill > 0.5) )
		{
			NextState = 'FallingState';
			NextLabel = 'FireWhileFalling';
		}
*/
	}
	else if ( (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z)
				&& (Momentum.Z/Region.Zone.ZoneGravity.Z < -0.5) )
		bFireFalling = true;
	else if (NextState == 'TakeHit')
		NextState = '';
}

function PlayHitAnim(vector HitLocation, float Damage)
{
	NextAnim = ''; 
	NextState = 'TakeHit';
	PlayTakeHit(0.08, hitLocation, Damage); 
} 

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	local Bubble1 bub;
	local UT_BloodBurst b;
	local vector Mo;

	if ( Region.Zone.bDestructive && (Region.Zone.ExitActor != None) )
		Spawn(Region.Zone.ExitActor);
	if (HeadRegion.Zone.bWaterZone)
	{
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * vector(Rotation) + 0.8 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.2 * CollisionRadius * VRand() + 0.7 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
		bub = spawn(class 'Bubble1',,, Location 
			+ 0.3 * CollisionRadius * VRand() + 0.6 * BaseEyeHeight * vect(0,0,1));
		if (bub != None)
			bub.DrawScale = FRand()*0.08+0.03; 
	}
	if ( !bGreenBlood && (DamageType == 'shot') || (DamageType == 'decapitated') )
	{
		Mo = Momentum;
		if ( Mo.Z > 0 )
			Mo.Z *= 0.5;
		spawn(class 'UT_BloodHit',self,,hitLocation, rotator(Mo));
	}
	else if ( (damageType != 'Burned') && (damageType != 'Corroded') 
		 && (damageType != 'Drowned') && (damageType != 'Fell') )
	{
		b = spawn(class 'UT_BloodBurst',self,'', hitLocation);
		if ( bGreenBlood && (b != None) ) 
			b.GreenBlood();
	}
}

function PlayDyingSound()
{
	local int rnd;

	if ( HeadRegion.Zone.bWaterZone )
	{
		if ( FRand() < 0.5 )
			PlaySound(UWHit1, SLOT_Pain,16,,,Frand()*0.2+0.9);
		else
			PlaySound(UWHit2, SLOT_Pain,16,,,Frand()*0.2+0.9);
		return;
	}

	rnd = Rand(6);
	PlaySound(Deaths[rnd], SLOT_Talk, 16);
	PlaySound(Deaths[rnd], SLOT_Pain, 16);
}

function PlayTakeHitSound(int damage, name damageType, int Mult)
{
	if ( Level.TimeSeconds - LastPainSound < 0.25 )
		return;
	LastPainSound = Level.TimeSeconds;

	if ( HeadRegion.Zone.bWaterZone )
	{
		if ( damageType == 'Drowned' )
			PlaySound(drown, SLOT_Pain, 12);
		else if ( FRand() < 0.5 )
			PlaySound(UWHit1, SLOT_Pain,16,,,Frand()*0.15+0.9);
		else
			PlaySound(UWHit2, SLOT_Pain,16,,,Frand()*0.15+0.9);
		return;
	}
	damage *= FRand();

	if (damage < 8) 
		PlaySound(HitSound1, SLOT_Pain,16,,,Frand()*0.2+0.9);
	else if (damage < 25)
	{
		if (FRand() < 0.5) PlaySound(HitSound2, SLOT_Pain,16,,,Frand()*0.15+0.9);
		else PlaySound(HitSound3, SLOT_Pain,16,,,Frand()*0.15+0.9);
	}
	else
		PlaySound(HitSound4, SLOT_Pain,16,,,Frand()*0.15+0.9);
}

defaultproperties
{
     Acquire=Sound'SHuman.M2incoming'
     syllable1=Sound'UnrealShare.Skaarj.syl07sk'
     syllable2=Sound'UnrealShare.Skaarj.syl09sk'
     syllable3=Sound'UnrealShare.Skaarj.syl11sk'
     syllable4=Sound'UnrealShare.Skaarj.syl12sk'
     syllable5=Sound'UnrealShare.Skaarj.syl13sk'
     syllable6=Sound'UnrealShare.Skaarj.syl15sk'
     spin=Sound'SHuman.TMJump3'
     claw=Sound'SHuman.TMJump3'
     slice=Sound'SHuman.TMJump3'
     lunge=Sound'SHuman.TMJump3'
     hairflip=Sound'UnrealShare.Skaarj.hairflp2sk'
     Die2=Sound'SHuman.deathc52'
     Die=Sound'SHuman.deathc53'
     Footstep=Sound'SHuman.Fstone02'
     Footstep1=Sound'SHuman.Fstone02'
     Footstep2=Sound'SHuman.Fstone04'
     Footstep3=Sound'SHuman.Fstone05'
     GaspSound=Sound'SHuman.hgasp1'
     drown=Sound'SHuman.drownM02'
     Threaten=Sound'SHuman.M2wantsome'
     HitSound1=Sound'SHuman.injurL2'
     HitSound2=Sound'SHuman.injurL04'
     HitSound3=Sound'SHuman.injurM04'
     HitSound4=Sound'SHuman.injurH5'
     Deaths(0)=Sound'SHuman.deathc1'
     Deaths(1)=Sound'SHuman.deathc51'
     Deaths(2)=Sound'SHuman.deathc3'
     Deaths(3)=Sound'SHuman.deathc4'
     Deaths(4)=Sound'SHuman.deathc53'
     Deaths(5)=Sound'SHuman.deathc52'
     UWHit1=Sound'SHuman.UWinjur41'
     UWHit2=Sound'SHuman.UWinjur42'
     Land=Sound'UnrealShare.Generic.Land1'
     LandGrunt=Sound'UnrealShare.Male.MLand3'
     JumpSound=Sound'SHuman.TMJump3'
     CarcassType=Class'UnrealShare.CreatureCarcass'
     MultiSkins(0)=Texture'GothSkins.goth1'
     MultiSkins(1)=Texture'GothSkins.goth2'
     MultiSkins(2)=Texture'GothSkins.goth3'
     MultiSkins(3)=Texture'GothSkins.T_Blue4'
     FaceSkin=1
     TeamSkin1=2
     TeamSkin2=3
     DefaultSkinName="CommandoSkins.cmdo"
     DefaultPackage="CommandoSkins."
     NameArticle=""
     MenuName=" Gopostal"
     Mesh=LodMesh'Botpack.Commando'
     Health=1500
}
