//=============================================================================
// NsSlithProjectile.
// Recreated for a nice view, decal, and... instigator LOLZ
//=============================================================================
class NsSlithProjectile extends Projectile;

var rotator RandRot;
var vector SurfaceNormal;	
var bool bInAir;
var float DotProduct;
var int i;

simulated function Timer()
{
	local GreenSmokePuff gsp;

	gsp = Spawn(class'GreenSmokePuff',,,Location+SurfaceNormal*9);
	if (i!=-1) 
	{
		if (LightBrightness > 10) LightBrightness -= 10;
//		DrawScale = 0.9*DrawScale;
//		gsp.DrawScale = DrawScale*5;
		i++;
		if (i>12) Explode(Location, vect(0,0,0));
	}
}

function Explode(vector HitLocation, vector HitNormal)
{
	local FlameBall f;
	if ( Instigator == None || instigator.health < 1)
		bReplicateInstigator = False;
  	HurtRadius(damage * DrawScale, DrawScale * 200, 'corroded', MomentumTransfer, HitLocation);
	Destroy();	
}
	
auto state Flying
{
	function ProcessTouch (Actor Other, vector HitLocation) 
	{ 
		if ( NsSlith(Other) == None )
			Explode(HitLocation, vect(0,0,0)); 
	}

	singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
							vector momentum, name damageType )
	{
		Explode(Location, vect(0,0,0));
	}

	function HitWall( vector HitNormal, actor Wall )
	{
		MakeNoise(0.6);	
		bInAir = False;
		PlaySound(ImpactSound);	
		SurfaceNormal = HitNormal;
		RandRot = rotator(HitNormal);
		RandRot.Roll += 32768;
		SetRotation(RandRot);	
		PlaySound(ImpactSound);		
		SetPhysics(PHYS_None);
		GoToState('OnSurface');
	}

	function BeginState()
	{	
		i=-1;
		if (FRand() < 0.5)
			DrawScale = 0.3 + 0.7 * FRand();
		Velocity = Vector(Rotation) * speed;	
		SetTimer(0.2,True);
		RotationRate.Yaw = Int(200000 * FRand()) - 100000;
		RotationRate.Pitch = Int(FRand() * (200000 - Abs(RotationRate.Yaw))) 
								- (100000 - Abs(RotationRate.Yaw)/2);
		LoopAnim('Flying',0.4);
		SurfaceNormal = Vect(0,0,0);
		bInAir=True;
		PlaySound(SpawnSound);
		if( Region.zone.bWaterZone )
			Velocity=Velocity*0.7;
	}
}

state OnSurface
{
	function ProcessTouch (Actor Other, vector HitLocation)
	{
		Explode(HitLocation, vect(0,0,0));
	}
Begin:
	i=0;
	PlayAnim('Hit');
	FinishAnim();
	DotProduct = SurfaceNormal dot vect(0,0,-1);
	If( DotProduct > 0.7 )
	{
		PlayAnim('Drip',0.1);
		FinishAnim();
	}
	else if (DotProduct > -0.5)
	{
		PlayAnim('Slide',0.2);
		Finishanim();
	}
}

defaultproperties
{
     speed=750.000000
     Damage=40.000000
     MomentumTransfer=20000
     SpawnSound=Sound'UnrealShare.Slith.SliSpawn'
     ImpactSound=Sound'UnrealShare.Slith.SliImpact'
     RemoteRole=ROLE_SimulatedProxy //yeah...
     bNetTemporary=False
     Mesh=LodMesh'UnrealShare.ngel'
     DrawScale=0.700000
     bUnlit=True
     CollisionRadius=6.000000
     CollisionHeight=4.000000
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=101
     LightHue=88
     LightSaturation=9
     LightRadius=4
     bBounce=True
     bFixedRotationDir=True
}
