//=============================================================================
// WarlordRocket.
//=============================================================================
class ExWarlordRocket extends Projectile;

var vector OriginalDirection;
var float SmokeRate;

/*
function Tick(float DeltaTime)
{
	local SpriteSmokePuff b;

	Count += DeltaTime;
	if ( (Count>(SmokeRate+FRand()*SmokeRate)) && (Level.NetMode!=NM_DedicatedServer) ) 
	{
		b = Spawn(class'SpriteSmokePuff');
		b.RemoteRole = ROLE_None;
		Count=0.0;
	}
}
*/
auto state Flying
{
	simulated function Timer()
	{
		local SpriteSmokePuff bs;

		if (Level.NetMode!=NM_DedicatedServer) 
		{
			bs = Spawn(class'SpriteSmokePuff');
			bs.RemoteRole = ROLE_None;
		}
		SetTimer(SmokeRate,True);
	}

	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ((PeaceRocket(Other) == none) && (Other != Instigator) ) 
			Explode(HitLocation, vect(0,0,0));
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		HurtRadius(damage, 200.0, 'exploded', MomentumTransfer, HitLocation);
		Spawn(class'SpriteBallExplosion', Pawn(Owner),,HitLocation);
		MakeNoise(1.0);
		Destroy();
	}

	simulated function AnimEnd()
	{
		LoopAnim('Flying');
		Disable('AnimEnd');
	}

	simulated function BeginState()
	{
		if ( Level.NetMode != NM_DedicatedServer )
		{
			PlayAnim('Ignite',0.5);
			if (Level.bHighDetailMode) SmokeRate = 0.035;
			else SmokeRate = 0.35;
			PlaySound(SpawnSound);
			Timer();
		}
		OriginalDirection = Vector(Rotation);
		Velocity = OriginalDirection * 500.0;
		Acceleration = Velocity * 0.4;
	}

Begin:
	Sleep(7.0);
	Explode(Location, vect(0,0,0));
}

defaultproperties
{
     ExplosionDecal=Class'Botpack.BlastMark'
     RemoteRole=ROLE_SimulatedProxy
     speed=1200.000000
     MaxSpeed=1200.000000
     Damage=60.000000
     MomentumTransfer=50000
     bNetTemporary=False
     AmbientSound=Sound'UnrealI.General.BRocket'
     Mesh=LodMesh'UnrealI.perock'
     DrawScale=2.500000
     AmbientGlow=5
     bUnlit=True
     SoundRadius=20
     SoundVolume=255
//   bBounce=True
}
