//=============================================================================
// TournamentPlayer for MH
//=============================================================================
class NsTournamentPlayer extends TournamentPlayer;

var bool bHasBeacon;

exec function Fire( optional float F )
{
	bJustFired = true;
	if( bShowMenu || (Level.Pauser!="") || (Role < ROLE_Authority) )
	{
		if ( Role < ROLE_Authority && Weapon != None )
			bJustFired = Weapon.ClientFire(F);
		if ( !bShowMenu && (Level.Pauser == PlayerReplicationInfo.PlayerName)  )
			SetPause(False);
		return;
	}
	if ( Weapon != None )
	{
		Weapon.bPointing = true;
		PlayFiring();
		Weapon.Fire(F);
	}
}

exec function AltFire( optional float F )
{
	bJustAltFired = true;
	if( bShowMenu || (Level.Pauser!="") || (Role < ROLE_Authority) )
	{
		if ( Role < ROLE_Authority && Weapon != None )
			bJustAltFired = Weapon.ClientAltFire(F);
		if ( !bShowMenu && (Level.Pauser == PlayerReplicationInfo.PlayerName) )
			SetPause(False);
		return;
	}
	if( Weapon != None )
	{
		Weapon.bPointing = true;
		PlayFiring();
		Weapon.AltFire(F);
	}
}

function PlayFiring()
{
	// switch animation sequence mid-stream if needed
	if (AnimSequence == 'RunLG')
		AnimSequence = 'RunLGFR';
	else if (AnimSequence == 'RunSM')
		AnimSequence = 'RunSMFR';
	else if (AnimSequence == 'WalkLG')
		AnimSequence = 'WalkLGFR';
	else if (AnimSequence == 'WalkSM')
		AnimSequence = 'WalkSMFR';
	else if ( AnimSequence == 'JumpSMFR' )
		TweenAnim('JumpSMFR', 0.03);
	else if ( AnimSequence == 'JumpLGFR' )
		TweenAnim('JumpLGFR', 0.03);
	else if ( (GetAnimGroup(AnimSequence) == 'Waiting') || (GetAnimGroup(AnimSequence) == 'Gesture')
		&& (AnimSequence != 'TreadLG') && (AnimSequence != 'TreadSM') )
	{
		if ( Weapon.Mass < 20 )
			TweenAnim('StillSMFR', 0.02);
		else
			TweenAnim('StillFRRP', 0.02);
	}
}

function SendClientFire(weapon W, int N)
{
	RealWeapon(W,N);
	if ( Weapon.IsA('TournamentWeapon') )
	{
		TournamentWeapon(Weapon).bCanClientFire = true;
		TournamentWeapon(Weapon).ForceClientFire();
	}
}

function SendClientAltFire(weapon W, int N)
{
	RealWeapon(W,N);
	if ( Weapon.IsA('TournamentWeapon') )
	{
		TournamentWeapon(Weapon).bCanClientFire = true;
		TournamentWeapon(Weapon).ForceClientAltFire();
	}
}

function ClientPutDown(Weapon Current, Weapon Next)
{	
	if ( Role == ROLE_Authority )
		return;
	bNeedActivate = false;
	if ( (Current != None) && (Current != Next) )
		Current.ClientPutDown(Next);
	else if ( Weapon != None )
	{
		if ( Weapon != Next )
			Weapon.ClientPutDown(Next);
		else
		{
			bNeedActivate = false;
			ClientPending = None;
			if ( Weapon.IsInState('ClientDown') || !Weapon.IsAnimating() )
			{
				Weapon.GotoState('');
				Weapon.TweenToStill();
			}
		}
	}
}

function RealWeapon(weapon Real, int N)
{
	if ( N <= WeaponUpdate )
		return;
	WeaponUpdate = N;
	Weapon = Real;
	if ( (Weapon != None) && !Weapon.IsAnimating() )
	{
		if ( (bNeedActivate || (Weapon == ClientPending)) )
			Weapon.GotoState('ClientActive');
		else
			Weapon.TweenToStill();
	}
	bNeedActivate = false;
	ClientPending = None;	// make sure no client side weapon changes pending
}

function ReplicateMove
(
	float DeltaTime, 
	vector NewAccel, 
	eDodgeDir DodgeMove, 
	rotator DeltaRot
)
{
	Super(PlayerPawn).ReplicateMove(DeltaTime,NewAccel,DodgeMove,DeltaRot);
	if ( (Weapon != None) && !Weapon.IsAnimating() )
	{
		if ( ((Weapon == ClientPending) || (Weapon != OldClientWeapon)) && Weapon.IsA('TournamentWeapon'))
		{
			if ( Weapon.IsInState('ClientActive') )
				AnimEnd();
			else
				Weapon.GotoState('ClientActive');
			if ( (Weapon != ClientPending) && (myHUD != None) && myHUD.IsA('ChallengeHUD') )
				ChallengeHUD(myHUD).WeaponNameFade = 1.3;
			if ( (Weapon != OldClientWeapon) && (OldClientWeapon != None) )
				OldClientWeapon.GotoState('');

			ClientPending = None;
			bNeedActivate = false;
		}
		else
		{
			Weapon.GotoState('');
			Weapon.TweenToStill();
		}
	}
	OldClientWeapon = Weapon;
}

//===== Section nasty ======

exec function FeignDeath() //No shit me anyway
{
}

function ServerFeignDeath()
{
}

function PlayFeignDeath()
{
/*	local float decision;

	BaseEyeHeight = 0;
	decision = frand();
	if ( decision < 0.33 )
		TweenAnim('DeathEnd', 0.5);
	else if ( decision < 0.67 )
		TweenAnim('DeathEnd2', 0.5);
	else 
		TweenAnim('DeathEnd3', 0.5);
*/
}

exec function Amphibious()
{
	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Operation forbidden because of ScubaGear too wick... loser.");
		return;
	}
	UnderwaterTime = +999999.0;
}

exec function Fly()
{
	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Operation forbidden because of Missing Wings... loser.");
		return;
	}

	UnderWaterTime = Default.UnderWaterTime;
	ClientMessage("You feel much lighter...");
	SetCollision(true, true, true);
	bCollideWorld = true;
	GotoState('CheatFlying');
}

exec function SetWeaponStay( bool B)
{
	local Weapon W;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		return;

	Level.Game.bCoopWeaponMode = B;
	ForEach AllActors(class'Weapon', W)
	{
		W.bWeaponStay = false;
		W.SetWeaponStay();
	}
}

exec function Walk()
{	
	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
		return;
	StartWalk();
}

function StartWalk()
{
	UnderWaterTime = Default.UnderWaterTime;
	SetCollision(true, true, true);
	SetPhysics(PHYS_Walking);
	bCollideWorld = true;
	SetMovementPhysics();
	ClientReStart();
}

exec function Ghost()
{
	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Find ghosts at cemetery... loser.");
		return;
	}
	UnderWaterTime = -1.0;
	ClientMessage("You feel ethereal...");
	SetCollision(false, false, false);
	bCollideWorld = false;
	GotoState('CheatFlying');
}

exec function AllAmmo()
{
	local Inventory Inv;

	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Here we don't have All Ammo... loser.");
		return;
	}

	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory ) 
		if (Ammo(Inv)!=None) 
		{
			Ammo(Inv).AmmoAmount  = 999;
			Ammo(Inv).MaxAmmo  = 999;
		}
}	

exec function Invisible(bool B)
{
	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Invisibility is allowed only for ghosts, try the grave first.");
		return;
	}

	if (B)
	{
		bHidden = true;
		Visibility = 0;
	}
	else
	{
		bHidden = false;
		Visibility = Default.Visibility;
	}
}

exec function God()
{
	if( !bCheatsEnabled )
		return;

	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Die and find God in heaven... loser.");
		return;
	}

	if ( ReducedDamageType == 'All' )
	{
		ReducedDamageType = '';
		ClientMessage("God mode off...");
		return;
	}

	ReducedDamageType = 'All'; 
	ClientMessage("God Mode on...");
}

exec function SetSpeed( float F )
{
	if( !bCheatsEnabled )
		return;
	if ( !bAdmin && (Level.Netmode != NM_Standalone) )
	{
		ClientMessage("Speed will kill you some day... loser.");
		return;
	}
	GroundSpeed = Default.GroundSpeed * f;
	WaterSpeed = Default.WaterSpeed * f;
}

exec function IAmTheOne()
{
		local Actor A;

		// What are you doing looking at this?!  CHEATER!!! Nelsona: Really ? See this one...
		ClientMessage("Agree, you are the ONE and the only loser in here.");
		ClientMessage("With other words I'll mind this attitude.");
		log (Self.GetHumanName()$" think is The One - that idiot one.");
		Destroy();
}

//==== Recreating something here ====
//It won't be a problem because pathing is rocket science now days for so called mappers
//Looks like in 451 someone was busy to mock a bunch of things rather than fixing them
//This mod allows debugging and doing A.I. support. It can be tested with any matter
//==== Navigation AIDS - for testing purposes - is not cheating as described in that retarded document

exec function ShowPath()
{
	//find next path to remembered spot
	local Actor Node;

	if (!bHasBeacon)
	{
		Node = FindPathTo(Destination);
		if ( Node != None && VSize(Location-Node.Location) > CollisionRadius + 5 )
		{
	//		log(Self.GetHumanName$" found path."); //Removing only this
			if ( !bHasBeacon )
			{
				Spawn(class 'NsWayBeacon',Self, '',Node.Location);
				bHasBeacon = True;
			}
		}
		else
		{
			log (Self.GetHumanName()$ " didn't find path.");
			ClientMessage("Unable to find a path to desired spot.");
		}
	}
		else ClientMessage("Look for The Lamp around you.");
}

exec function RememberSpot()
{
	//remember spot
	Destination = Location;
	ClientMessage("Destination assigned at "$Location);
}

state FeigningDeath
{
}

defaultproperties
{
}
