//=============================================================================
// DMMutator converted to Other Mutator
//=============================================================================
class NsDeathMatchMutator expands Mutator;

var DeathMatchPlus MyGame;
var float md;
var CaptureActor CaptActor;

event PostBeginPlay()
{
	Spawn(class 'CaptureActor');
	MyGame = DeathMatchPlus(Level.Game);
	Level.Game.RegisterDamageMutator(Self);
	Level.Game.RegisterMessageMutator(Self);
//	SetTimer(Level.TimeDilation,True);
	Super.PostBeginPlay(); //Do different stuff first and let me finish if still exist troubles
	SetUpCurrent();
	FixMovers();
	TuneSpeed();
	NavigSlow();
}

function TuneSpeed()
{
	if ( Level.NetMode != NM_Standalone )
		spawn(class'AlignS');
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA('StationaryPawn') )
	{
		StationaryPawn(Other).NetUpdateFrequency = 20.000000;
//		StationaryPawn(Other).bGameRelevant = True;
	}

	if ( Other.IsA('ScriptedPawn'))
	{
		ScriptedPawn(Other).NetUpdateFrequency = 20.000000;
		ScriptedPawn(Other).NetPriority = 3.000000;
		ScriptedPawn(Other).bCanOpenDoors = True;
		ScriptedPawn(Other).bCanDoSpecial = True;
		if ((Level.Game).Difficulty < 4)
			ScriptedPawn(Other).Skill = (Level.Game).Difficulty;
	}

	if (Other.bIsPawn && Pawn(Other).bIsPlayer && !Other.IsA('ScriptedPawn'))
		Other.bAlwaysRelevant = True;

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;
	local Weapon W;

	// replace Unreal I inventory actors by their Unreal Tournament equivalents
	// set bSuperRelevant to false if want the gameinfo's super.IsRelevant() function called
	// to check on relevancy of this actor.
////////////////////////////////////
	// Nelsona notes: I won't replace anything except crappy weps developed by your specific ignorance
	// I expect Monsters in troubles at replacements but I don't think is so bad this time

	if (Other.IsA('Weapon'))
	{
		if( Other.Class == Class'minigun2')
		{
			ReplaceWith(Other,"NsDM3.Eminigun2");
			return false;
		}
		if( Other.Class == Class'PulseGun')
		{
			ReplaceWith(Other,"NsDM3.EPulseGun");
			return false;
		}
		if (Other.IsA('SuperShockRifle'))
		{
			ReplaceWith(Other, "BotPack.ShockRifle");
			return False;
		}
		if ( Other.Class == Class 'UT_Eightball' )
		{
			ReplaceWith(Other, "NsDM3.EUT_Eightball");
			return False;
		}
		if (Other.IsA('Quadshot'))
		{
			ReplaceWith(Other, "UnrealI.FlakCannon"); //Is using the same ammo in case of questions
			return False;
		}
		if (Other.IsA ('Translocator') && !Other.IsA('CTFTranslocator'))
		{
			ReplaceWith(Other, "NsDM3.CTFTranslocator");
			return False;
		}
		bSuperRelevant = 0;
	}
	if ( Other.IsA('Inventory') )
	{
		if (Other.IsA('Pickup'))
			Pickup(Other).bAutoActivate = true;
		if (Other.IsA('Ammo'))
			Ammo(Other).RespawnTime = FClamp ( Ammo(Other).RespawnTime-5,10,15 );
		Inventory(Other).PickupMessageClass = Class'Botpack.PickupMessagePlus';
		if (Other.Class == Class 'Amplifier')
		{
			if ( Amplifier(Other).Charge == Amplifier(Other).Default.Charge )
				Amplifier(Other).Charge *= 5;
		}
		if (Other.IsA('Invisibility') || Other.IsA('UT_invisibility'))
		{
			ReplaceWith( Other, "UnrealShare.WeaponPowerUp" );
			return False;
		}
		if ( Other.IsA('JumpBoots') )
		{
			if ( MyGame.bJumpMatch )
			return false;
		}
		return True;
	}
	if (Other.Isa('WayBeacon'))
	{
		Other.NetUpdateFrequency = 5.000000;
		Other.RemoteRole = ROLE_DumbProxy;
		Other.AmbientGlow = 200;
		Other.LightEffect = LE_NonIncidence;
		Other.LightBrightness = 200;
		Other.LightRadius = 10;
	}
	bSuperRelevant = 1;
	if ( MyGame.bMegaSpeed && Other.bIsPawn )
	{
		Pawn(Other).GroundSpeed *= 1.4;
		Pawn(Other).WaterSpeed *= 1.4;
		Pawn(Other).AirSpeed *= 1.4;
		Pawn(Other).AccelRate *= 1.4;
	}

	if ( Other.IsA('StationaryPawn') )
		return true;

	if ( Other.IsA('ScriptedPawn') )
		return true;

	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
	}
	bSuperRelevant = 0;
	return true;
}
//////////
// Next lines are added at my requests
//////////
function bool ReplaceWith(actor Other, string aClassName) //reworking this stupid one for different reasons
{
	local Actor A;
	local class<Actor> aClass;
	local Pawn P;
	local Weapon W;
	local Rotator DropRot;
	local float ORadius, OHeight;

//	log ("Attempt replacing "$Other$" at "$GetAbsoluteTime());
	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;
//Add-ons - Save primary collision and reduce manure to not mess the newer
	ORadius = Other.CollisionRadius;
	OHeight = Other.CollisionHeight;
	Other.SetCollisionSize(1,1);
//End Adds
	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
	{
		aClass.Default.bCollideWhenPlacing = False; //weaponry spawned won't fall speaking from experience so get right here, right now
		A = Spawn(aClass,Other.Owner,Other.tag,Other.Location+vect(0,0,1),Other.Rotation); //Timer Solved so monster should not mess up, else fix coming
	}
	if ( Other.IsA('Inventory') && A != None ) //Presume inventory and do not touch it if new thing is missing - POSSIBLE !!!
	{
		if ( Inventory(Other).MyMarker != None ) //Check for it if is marked as part of a path placed in map 
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A); //Try to mark New thing
			if ( Inventory(A) != None ) //Is inventory ?
			{
				Inventory(A).SetCollisionSize(1,1); //SMALL!
				Inventory(A).MyMarker = Inventory(Other).MyMarker; //copy data from old thing
				A.SetLocation(Other.Location+vect(0,0,1));
/*
				A.SetLocation(A.Location 
					+ (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1)); //move it a lil
*/
				Inventory(A).bRotatingPickup=Inventory(Other).bRotatingPickup;
			}
			Inventory(Other).MyMarker = None; //remove marker from old - it will be destroyed soon
		}
// To work here - Time to examine if this crap is not spawned by monster or a stupid WoodenBox - thanks for Accesed Nones
		else if ( A.IsA('Inventory') && Inventory(Other).Instigator != None
			&& Inventory(Other).Instigator.bIsPawn && Vsize(A.Location-Other.Instigator.Location) <= A.CollisionRadius ) //Modification in here - Checking if has a Pawn Instigator
		{
			Inventory(A).Respawntime = 0.0;	//Agree ONLY if belongs to a PAWN, morons !
			Inventory(A).bHeldItem = True;	//Yes is holded, else I promise it will be holded very soon...
			if (Inventory(A).IsA('Weapon'))
			{
				W = Weapon(Inventory(A)); //We speak about weapon - Not Very TournamentWeapon ?
				W.PickupMessageClass = Class'Botpack.PickupMessagePlus'; //Made sure of good things :D
				if ( Other.Instigator.Health > 0 )
				{
					P = Other.Instigator; //describe instigator if exist anyone alive
					W.Instigator = P; //Let me see this, assign instigator copying it from old thing
					if ( P.FindInventoryType(aClass) == None ) //This guy owns new thing or... timing went wrong so is unarmed ?
					{
						log ("Found Instigator Pawn "$P$" for "$Inventory(A)$" as replacement for "$Other$"."); //LOLz, it just failed weapon
						if (!P.bIsPlayer) //Fix it to gain stuff if is not a good one
							P.bIsPlayer=True;
						W.Touch(P); //Then call properly original pawn code used before to screw with replacement - probably will end bIsPlayer carrer - else awaiting timer to manage shite
					}
				}
			}
		}
// Will check if still bug me. No, it looks fine.
		else // YAY - now probably 0 pawn spawned this thing, or is just dropped, or is some Decoration Content - time to end bullshit
		{
			if ( Inventory(A).MyMarker == None )
			{
				Inventory(A).RemoteRole = ROLE_DumbProxy; //is indeed something felt - no marker, remember ? No waste resources.
				Inventory(A).bCollideWorld = True; //Do not fall into void
				DropRot = Other.Rotation;
				DropRot.Pitch = Rand(32768);
				DropRot.Yaw = Rand(65536);
				Inventory(A).Velocity = vector(DropRot) * RandRange(250,301);
				Inventory(A).Velocity.Z = RandRange(250,451);
				Inventory(A).SetPhysics(PHYS_Falling); //because you will fall
				Inventory(A).GotoState('Pickup', 'Dropped'); //And you're a pathetic pickup in end
//				log (Other$" spawned at "$Other.Location$" having RespawnTime "$Inventory(Other).RespawnTime);
				if ( CaptActor.bHaveASpawn )
				{
					log ("New actor "@A@" won't respawn.");
					Inventory(A).RespawnTime = 0.00; //do not respawn shit dropped by pawns - could be a bunch messing up around
				}
				else
				{
					Inventory(A).RespawnTime = Inventory(Other).RespawnTime;
					log ("New actor "@Inventory(A)@" will have respawntime "@Inventory(A).RespawnTime@".");
				}
			}
		}
	}
	else
	{
		log (Other$" looks like shit placed at "$Other.Location$". Bye !!!");
		Other.SetCollisionSize(ORadius,OHeight);
	}
	if ( A != None )
	{
		if ( Inventory(A) != None && Inventory(A).MyMarker != None ) //Not sure
			A.SetCollisionSize(ORadius,OHeight);
		A.event = Other.event;
		A.tag = Other.tag;
		A.RotationRate = Other.RotationRate; //Agree
		A.bFixedRotationDir = Other.bFixedRotationDir;
//		log ( Other$" is now "$A );
		return true;
	}
	return false;
}

function SetUpCurrent()
{
	spawn(class'PawnNotify');
	spawn(class'Tweaker');
}

function NavigSlow()
{
	local NavigationPoint NP;
	local CaptureActor Ac;

	foreach AllActors(class 'NavigationPoint', NP)
	{
		if (NP != None)
		{
			NP.NetUpdateFrequency = 5.000000; //Why more ?
			if (NP.IsA('LiftCenter'))
				NP.RemoteRole = ROLE_DumbProxy; //Why was None ?
		}
	}

	foreach Level.AllActors (class'CaptureActor', Ac)
	{
		if ( Ac != None )
		{
			CaptActor = Ac;
			log ("Base Mutator found CaptureActor.");
			break;
		}
	}
}

function FixMovers()
{
	local mover M;
	local Trigger T;

	foreach AllActors(class 'Mover', M)
	{
	if (M != None)
		{
		M.NetUpdateFrequency = 10.000000;
//		log ("Mover "@M@" updated to frequency "@M.NetUpdateFrequency);
			if (M.MoverEncroachType == ME_CrushWhenEncroach && !M.bTriggerOnceOnly)
			{
				M.BumpType = BT_PawnBump;	//If I was killed why Bot need to not be killed, even is blocked, fag ?
				if (M.EncroachDamage <= 0)
					M.EncroachDamage = 5000000;
			}
		foreach AllActors (class 'Trigger', T)
			{
			if (T != None && T.Event == M.Tag && !M.bTriggerOnceOnly && T.InitialState == 'NormalTrigger' && !T.bTriggerOnceOnly )
				if ( T.TriggerType == TT_PlayerProximity )
				{
					T.TriggerType = TT_PawnProximity;
					T.ClassProximityType = class 'Pawn';
				}
			}

		if ( M.bTriggerOnceOnly )
		{
			if (M.MoverEncroachType == ME_ReturnWhenEncroach)
			{
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
				log ("Detected & Resolved a Mover Triggered Once With ReturnWhenEncroach >> "@M.name);
			}
			if ( M.InitialState == 'TriggerControl' )
			{
				log ("Ass ? A mover with TriggerControl shouldn't be set bTriggerOnceOnly >> "@M.Name);
				log ("Attempt to fix mover state >> "@M.Name@" to TriggerOpenTimed.");
				M.InitialState = 'TriggerOpenTimed';
				if ( M.InitialState == 'TriggerOpenTimed' )
					log ("Succesfully fixed.");
				else
					log ("Fixing failed !!!");
			}
		}
		if (!M.bTriggerOnceOnly && M.InitialState == 'TriggerControl')
		{
			if (M.MoverEncroachType == ME_StopWhenEncroach)
				M.MoverEncroachType = ME_IgnoreWhenEncroach;
		}
		if (M.bUseTriggered == True)
		{
			M.bUseTriggered = False;
			log ("Detected & Resolved a Mover to not be cheated by GRAB command >> " @M.name);
		}
		if (M.bDamageTriggered)
			log(M@" >> is damage triggered");
		if (!M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
		{
			M.MoverEncroachType = ME_CrushWhenEncroach; //Camping under lifts bad ideea for lamers :P
			M.EncroachDamage = 5000000;
			log ("Detected & Resolved a Mover to not be turned back without to suffer a big damage >> "@M.name);
		}
		if (!M.bTriggerOnceOnly && M.DelayTime < md)
		{
			M.DelayTime = md; //Expect some ping reaction for NetworkPlay
		}
		if (!M.bTriggerOnceOnly && M.BumpType == BT_PlayerBump && ( M.InitialState == 'StandOpenTimed' || M.InitialState == 'BumpOpenTimed' || M.InitialState == 'BumpButon'))
		{
			M.BumpType = BT_PawnBump; //Enhanced mover, LOL, monsters will use it to hunt you back :P
		}
		}
	}
}

function ModifyPlayer(Pawn Other)
{
	local Triggerator T;

	if ( !Other.bIsPlayer || Other.PlayerReplicationInfo == None ) //Not sure if this one will be ever used
		return; //But block craps in here if something goes wrong

	Super.ModifyPlayer(Other); //I'll return later so mind other stuff first

	if ( Other.IsA('PlayerPawn') && !Other.bHidden )
	{
		foreach Other.ChildActors(class 'Triggerator',T)
		{ return; }
		T = Spawn(class'Triggerator',Other);
	}
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	local bool PD;
	local Actor T;
	local Pawn P;
	local int i;
	local inventory Inv;
	local weapon weap;
	local float speed;

	PD = Super.PreventDeath(Killed,Killer,DamageType,HitLocation);
	if ( Killed != none )
	{
		if ( Killed.PlayerReplicationInfo == None )
		{
			DiscardInventory(Killed);
			foreach Killed.RadiusActors (class'Actor',T,700)
			{
				if ( T != None )
				{
					foreach T.TouchingActors(class'Pawn',P)
					{
						if ( P != None && P == Killed && T.Tag != '' && Killed.Event != T.Tag )
							T.UnTouch( Killed );
					}
/*
					for (i=0;i<4;i++)
					{
						if (T.Touching[i] == Killed && !T.IsA('Mover') && Killed.Event != T.Tag)
							T.UnTouch( Killed );
					
						if (T.IsA('Mover') && Mover(T).Instigator != None && Mover(T).Instigator == Killed && !Mover(T).bTriggerOnceOnly && Killed.Event != Mover(T).Tag )
							Mover(T).UnTrigger(Killed,Instigator);
					}
*/
				}
			}
//			CheckTouchers();
			if ( !Killed.IsInState('Dying') )
				Killed.GoToState('Dying');
		}
	}
	return PD;
	return false;
}

function DiscardInventory (Pawn Other)
{
	local Actor dropped;
	local Inventory Inv;
	local class<Weapon> Initial1;
	local class<Weapon> Initial2;

	if (Other != none)
	{
	Inv=Other.Inventory;
	Loop1:
		if ( Inv != None )
		{
			if ( Inv.IsA('Weapon') )
			{
				if ( (Inv.Class != Level.Game.BaseMutator.MutatedDefaultWeapon()) && ((Weapon(Inv).AmmoType == None) || (Weapon(Inv).AmmoType.AmmoAmount > 0)) && Weapon(Inv).bCanThrow)
				{
					if ( Inv.class != class'Enforcer' && Inv.Class != class'DoubleEnforcer' ) //Doh...
						DropWeapon(Other,Inv);
				}
			}
			Inv.Destroy();
			Inv=Inv.Inventory;
			goto Loop1;
    	}
   	}
}

function DropWeapon (Pawn Other, Inventory Inv)
{
	local Inventory DropInv;
	local int DropPitch;
	local int DropYaw;
	local Rotator DropRot;

	DropInv=Spawn(Inv.Class,,,Other.Location);
	if ( DropInv == None )
		return;
	if ( DropInv.Region.Zone == None )
	{
		DropInv.Destroy();
		return;
	}
	DropRot=Other.ViewRotation;
	DropPitch=Rand(32768);
	DropYaw=Rand(65536);
	DropRot.Pitch=DropPitch;
	DropRot.Yaw=DropYaw;
	Weapon(DropInv).bWeaponStay = false;
	DropInv.Velocity=vector(DropRot) * (Rand(250) + 250);
	DropInv.RespawnTime=0.00;
	DropInv.BecomePickup();
	DropInv.NetPriority = 1.400000;
	DropInv.NetUpdateFrequency = 10.000000;
	DropInv.RemoteRole = ROLE_DumbProxy;
	DropInv.SetPhysics(PHYS_Falling);
	DropInv.bCollideWorld=True;
	DropInv.GotoState('Pickup','dropped');
}

function checktouchers()
{
	local Actor A, Other;
	local int i;

	foreach AllActors (class 'Actor', Other)
	{
		if (Other.bDeleteMe /*|| ( Other.bIsPawn && Pawn(Other).Health < 0)*/ )
		{
			log ("Actor "$Other$ " found... checking status...");
			foreach Other.RadiusActors (Class 'Actor', A, 500)
			{
				if (A != None)
				{
					for (i=0;i<4;i++)
					if ( A.Touching[i] == Other )
					{
						log ("Found Invalid Toucher for "@A@" at "$A.Touching[i]$" being "$Other);
						A.Untouch(Other);
						A.Untrigger(Other,Instigator);
					}
				}
			}
		}
	}
}

function ModifyLogin(out class<playerpawn> SpawnClass, out string Portal, out string Options)
{
	local class<playerpawn> origSC;
	local class<Spectator>  specCls;

//	Log("SpawnClass:"@SpawnClass);		// Someone claims that Engine.Pawn makes it here.
	if ( SpawnClass == None )
		SpawnClass = class'TMale1';

	if ( NextMutator != None )
		NextMutator.ModifyLogin(SpawnClass, Portal, Options);

	if (!ClassIsChildOf(SpawnClass, class'NsTournamentPlayer'))
	{
		if ( SpawnClass == class'TBoss' )
			SpawnClass = class'NsTBoss';
		else if ( SpawnClass == class'TMale1' )
			SpawnClass = class'NsTMale1';
		else if ( SpawnClass == class'TMale2' )
			SpawnClass = class'NsTMale2';
		else if ( SpawnClass == class'TFemale1' ) 
			SpawnClass = class'NsTFemale1';
		else if ( SpawnClass == class'TFemale2' )
			SpawnClass = class'NsTFemale2';
	}
}
/*
function timer()
{
	log("Timer Sequence started at "$Level.Hour$":"$Level.Minute$":"$Level.Second$":"$Level.Millisecond);
}
*/
defaultproperties
{
     md=0.300000
}
