class CTFTranslocatorTarget expands TranslocatorTarget;

auto state Pickup
{
	simulated function Timer()
	{
		local Pawn P;

		if ( (Physics == PHYS_None) && (Role != ROLE_Authority)
			&& (RealLocation != Location) && (RealLocation != vect(0,0,0)) )
				SetLocation(RealLocation);

		//disruption effect
		if ( Disrupted() )
		{
			Spawn(class'Electricity',,,Location + Vect(0,0,6));
			PlaySound(sound'TDisrupt', SLOT_None, 4.0);
			MakeNoise(0.8);
		}
		else
		{
			MakeNoise(0.8);
			// tell local bots about self and...
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsA('Bot') && (P.Weapon != None) && !P.Weapon.bMeleeWeapon
					&& (!Level.Game.bTeamGame || (P.PlayerReplicationInfo != None && Pawn( Master.Owner ).PlayerReplicationInfo != None
					&& P.PlayerReplicationInfo.Team != Pawn(Master.Owner).PlayerReplicationInfo.Team)) )
				{
					if ( (VSize(P.Location - Location) < 600) && P.LineOfSightTo(self) )
					{
						Bot(P).ShootTarget(self);
						break;
					}
					else if ( P.IsA('Bot') && (P.Weapon != None) && !P.Weapon.bMeleeWeapon
						&& (!Level.Game.bTeamGame || ((P.PlayerReplicationInfo.Team != Pawn(Master.Owner).PlayerReplicationInfo.Team) && P.PlayerReplicationInfo != None)) )
					{
						if ( (VSize(P.Location - Location) < 500) && P.LineOfSightTo(self) )
						{
							Bot(P).ShootTarget(self);
							break;
						}
						else if ( P.IsInState('Roaming') && Bot(P).bCamping
								&& Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).CheckThisTranslocator(Bot(P), self) )
						{
							Bot(P).SetPeripheralVision();
							Bot(P).TweenToRunning(0.1);
							Bot(P).bCamping = false;
							Bot(P).GotoState('Roaming', 'SpecialNavig');
							break;
						}
					}
				}
			}
		}
		AnimEnd();
		SetTimer(1 + 2 * FRand(), false);
	}

	event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		SetPhysics(PHYS_Falling);
		Velocity = Momentum/Mass;
		Velocity.Z = FMax(Velocity.Z, 0.7 * VSize(Velocity));
		if ( (Level.Game.bTeamGame && ( EventInstigator != None )
			&& ( EventInstigator.PlayerReplicationInfo != None )
			&& ( EventInstigator.PlayerReplicationInfo.Team == Instigator.PlayerReplicationInfo.Team )
			&& Instigator.PlayerReplicationInfo != None ) || Instigator == None )
			return;
		if ( Damage > 0 )
			Disruption += Damage;
		Disruptor = EventInstigator;
		if ( !Disrupted() )
			SetTimer(0.3, false);
		else if ( Glow != None )
			Glow.Destroy();
	}

	singular function Touch( Actor Other )
	{
		local bool bMasterTouch;
		local vector NewPos;

		if ( !Other.bIsPawn /*|| !Pawn(Other).bIsPlayer */)
		{
			if ( (Physics == PHYS_Falling) && !Other.IsA('Inventory') && !Other.IsA('Triggers') && !Other.IsA('NavigationPoint') )
				HitWall(-1 * Normal(Velocity), Other);
			return;
		}
		bMasterTouch = ( Other == Instigator );
		
		if ( Physics == PHYS_None )
		{
			if ( bMasterTouch )
			{
				PlaySound(Sound'Botpack.Pickups.AmmoPick',,2.0);
				Master.TTarget = None;
				Master.bTTargetOut = false;
				if ( Other.IsA('PlayerPawn') )
					PlayerPawn(Other).ClientWeaponEvent('TouchTarget');
				Destroy();
			}
			return;
		}
		if ( bMasterTouch ) 
			return;
		NewPos = Other.Location;
		NewPos.Z = Location.Z;
		SetLocation(NewPos);
		Velocity = vect(0,0,0);
		if (!Pawn(Other).bIsPlayer || Pawn(Other).PlayerReplicationInfo == None )
			goto EndedCrap;
		if ( Level.Game.bTeamGame
			&& (Instigator.PlayerReplicationInfo.Team == Pawn(Other).PlayerReplicationInfo.Team)
			&& Pawn(Other).PlayerReplicationInfo != None && Instigator.PlayerReplicationInfo != None)
			return;
EndedCrap:
		if ( Instigator.IsA('Bot') && Instigator != None && Bot(Instigator).Health > 0 )
			Master.Translocate();
	
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		if ( bAlreadyHit )
		{
			bBounce = false;
			return;
		}
		bAlreadyHit = ( HitNormal.Z > 0.7 );
		PlaySound(ImpactSound, SLOT_Misc);		// hit wall sound
		Velocity = 0.3*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		speed = VSize(Velocity);
		if ( Instigator != None && Instigator.IsA('Bot') && Bot(Instigator).Health > 0 )
		{
			if ( Bot(Instigator).bCanTranslocate )
				Master.Translocate(); //Insist a bit, meh...
			else Destroy();
		}
	}
}

defaultproperties
{
     Tag='AITag'
}
