class Tweaker extends Actor;

var bool bInitialized;

function PostBeginPlay()
{
	if (bInitialized) return;
	bInitialized = True;
	SetTimer(1.50,True);
	log ("A tweaker has been spawned.");
	Super.PostBeginPlay();
}

singular event timer()
{
	local ScriptedPawn S;
	local Pawn P, En;
	local name gstate;

	for (P=Level.PawnList; P!=None; P=P.NextPawn)
	{
		S = ScriptedPawn(P);
		if ( S != None && S.Health > 0 && S.PlayerReplicationInfo == None )
		{
//			S.bIsPlayer = False;
			if ( S.IsA('Nali') || S.IsA('Cow') )
				continue;
			foreach S.VisibleActors ( class 'Pawn', En, S.SightRadius*3 )
			{
				if ( En != None && En != S && En.Health > 0 && !En.bHidden
					&& ( En.PlayerReplicationInfo != None && En.PlayerReplicationInfo.Team != S.Team ) )
				{
					gstate = S.GetStateName();
					if ( S.Enemy == None  || ( S.Enemy != None && VSize(S.Enemy.Location-S.Location) > Vsize( En.Location-S.Location )))
					{
						if ( !S.IsInState('Attacking') && (gstate != 'Dying') )
						{
							S.Hated = En;
							S.Enemy = En;
							S.LastSeenpos = En.Location;
							S.GotoState('Attacking');
						}
						if (En.IsA('Bot'))
						{
							if (Bot(En).Enemy == None || (VSize(S.Location - Bot(En).Location) < VSize(Bot(En).Enemy.Location-Bot(En).Location) ))
							Bot(En).Enemy = S;
						}
						break;
					}
				}
			}
			if ((Level.Game).bTeamGame)
			{
				if ( S.Enemy != None && S.Enemy.IsA('ScriptedPawn') && S.Enemy.PlayerReplicationInfo == None
					&& ( ( S.Team == ScriptedPawn(S.Enemy).Team ) || (S.TeamTag == ScriptedPawn(S.Enemy).TeamTag && S.TeamTag != '')) )
				{
					S.Hated = None;
					S.Enemy = None;
					S.bHunting = False;
					S.Target = None;
					if ( S.OldEnemy != None && S.OldEnemy.IsA('ScriptedPawn')
					&& ( (S.Team == ScriptedPawn(S.OldEnemy).Team) || (S.TeamTag == ScriptedPawn(S.OldEnemy).TeamTag && S.TeamTag != '') ))
						S.OldEnemy = None;
					S.GotoState('Waiting');
				}
			}
		}
	}
	if ((Level.Game).bGameEnded) Destroy();
}

defaultproperties
{
     RemoteRole=ROLE_None
     bGameRelevant=True
     bHidden=True
}