//=============================================================================
//EUT_Grenade.
//=============================================================================
class EUT_Grenade extends UT_Grenade;

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super(Projectile).PostBeginPlay();
	if ( Level.NetMode != NM_DedicatedServer )
		PlayAnim('WingIn');
	SetTimer(2.5+FRand()*0.5,false); //Grenade begins unarmed

	if ( Role == ROLE_Authority )
	{
		if (Instigator != None)
		{
			GetAxes(Instigator.ViewRotation,X,Y,Z);
			Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed +
				FRand() * 100);
		}
		Velocity.z += 210;
		MaxSpeed = 1000;
		RandSpin(50000);
		bCanHitOwner = False;
		if (Instigator != None && Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Disable('Tick');
			Velocity=0.6*Velocity;
		}
	}
}

defaultproperties
{
}
