//=============================================================================
// PulseGun.
// Some fixing for A.I. and so on
// Beam reworked and collision height when gets dropped... Too tall...
//=============================================================================
class EPulseGun extends PulseGun;

simulated event RenderOverlays( canvas Canvas )
{
	if ( AmmoType == None || ( Pawn(Owner) == None || Pawn(Owner).Health <= 0 ) )
		return;
	Texture'Ammoled'.NotifyActor = Self;
	if (Pawn(Owner) != None)
		Super.RenderOverlays(Canvas);
	Texture'Ammoled'.NotifyActor = None;
}

simulated event RenderTexture(ScriptedTexture Tex)
{
	local Color C;
	local string Temp;

	if ( AmmoType == None ) return;
	if ( AmmoType.AmmoAmount == 0 ) Temp = "000";
	if ( Pawn(Owner) != None && !bHidden )
	{
//		log ( Self$" my Owner is "$Owner.GetHumanName());
//		log (Self$" my state: "$GetStateName());
		Temp = String(AmmoType.AmmoAmount);
//		log (Self$ " have Temp: "$Temp);
		while(Len(Temp) < 3) Temp = "0"$Temp;
		Tex.DrawTile( 30, 100, (Min(AmmoType.AmmoAmount,AmmoType.Default.AmmoAmount)*196)/AmmoType.Default.AmmoAmount, 10, 0, 0, 1, 1, Texture'AmmoCountBar', False );
		if ( AmmoType.AmmoAmount < 10 )
		{
			C.R = 255;
			C.G = 0;
			C.B = 0;
		}
		else
		{
			C.R = 0;
			C.G = 0;
			C.B = 255;
		}
		Tex.DrawColoredText( 56, 14, Temp, Font'LEDFont', C );
	}
}

simulated function TweenToStill() //LOL
{
	if ( Mesh != PickupViewMesh )
		TweenAnim('Still', 0.1);
}

simulated function PlaySelect()
{
	bForceFire = false;
	bForceAltFire = false;
	bCanClientFire = false;
	if ( Mesh == PlayerViewMesh )
	{
		if ( !IsAnimating() || (AnimSequence != 'Select') )
			PlayAnim('Select',1.0,0.0);
	}
	if ( Owner != None )
		Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function TweenDown()
{
	if ( Mesh == PlayerViewMesh )
	{
		if ( IsAnimating() && (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
			TweenAnim( AnimSequence, AnimFrame * 0.4 );
		else
			PlayAnim('Down', 1.0, 0.05);
	}
}

function CheckVisibility()
{
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	if ( PawnOwner != None )
		if ( Owner.bHidden && (PawnOwner.Health > 0) && (PawnOwner.Visibility < PawnOwner.Default.Visibility) )
		{
			Owner.bHidden = false;
			PawnOwner.Visibility = PawnOwner.Default.Visibility;
		}
}

defaultproperties
{
     DownSound=Sound'Botpack.PulseGun.PulseDown'
     WeaponDescription="Classification: Plasma Rifle\n\nPrimary Fire: Medium sized, fast moving plasma balls are fired at a fast rate of fire.\n\nSecondary Fire: A bolt of green lightning is expelled for 100 meters, which will shock all opponents.\n\nTechniques: Firing and keeping the secondary fire's lightning on an opponent will melt them in seconds."
     InstFlash=-0.150000
     InstFog=(X=139.000000,Y=218.000000,Z=72.000000)
     AmmoName=Class'Botpack.PAmmo'
     PickupAmmoCount=60
     bRapidFire=True
     FireOffset=(X=15.000000,Y=-15.000000,Z=2.000000)
     ProjectileClass=Class'NsCTF3.ExPlasmaSphere'
     AltProjectileClass=Class'NsCTF3.EStarterBolt'
     shakemag=135.000000
     shakevert=8.000000
     AIRating=0.700000
     RefireRate=0.950000
     AltRefireRate=0.990000
     FireSound=Sound'Botpack.PulseGun.PulseFire'
     AltFireSound=Sound'Botpack.PulseGun.PulseBolt'
     SelectSound=Sound'Botpack.PulseGun.PulsePickup'
     MessageNoAmmo=" has no Plasma."
     DeathMessage="%o ate %k's burning plasma death."
     NameColor=(R=128,B=128)
     FlashLength=0.020000
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got a Pulse Gun"
     ItemName="Pulse Gun"
     PlayerViewOffset=(X=1.500000,Z=-2.000000)
     PlayerViewMesh=LodMesh'Botpack.PulseGunR'
     PickupViewMesh=LodMesh'Botpack.PulsePickup'
     ThirdPersonMesh=LodMesh'Botpack.PulseGun3rd'
     ThirdPersonScale=0.400000
     StatusIcon=Texture'Botpack.Icons.UsePulse'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzPF3'
     MuzzleFlashScale=0.400000
     MuzzleFlashTexture=Texture'Botpack.Skins.MuzzyPulse'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UsePulse'
     Mesh=LodMesh'Botpack.PulsePickup'
     bNoSmooth=False
     SoundRadius=64
     SoundVolume=255
     CollisionRadius=32.000000
     CollisionHeight=12.000000
}
